/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.entity;

import cofh.lib.block.entity.ITileLocation;
import cofh.lib.util.helpers.XpHelper;
import cofh.lib.xp.EmptyXpStorage;
import cofh.lib.xp.XpStorage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface ITileXpHandler
extends ITileLocation {
    default public boolean claimXP(Player player) {
        if (!this.getXpStorage().isEmpty()) {
            int xp = this.getXpStorage().getStored();
            XpHelper.addXPToPlayer(player, xp);
            this.getXpStorage().clear();
            return true;
        }
        return false;
    }

    default public void spawnXpOrbs(Level world, int xp, Vec3 pos) {
        if (world == null) {
            return;
        }
        while (xp > 0) {
            int orbAmount = ExperienceOrb.m_20782_((int)xp);
            xp -= orbAmount;
            world.m_7967_((Entity)new ExperienceOrb(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, orbAmount));
        }
    }

    default public XpStorage getXpStorage() {
        return EmptyXpStorage.INSTANCE;
    }
}

